﻿using System;
using System.Security.Cryptography;

namespace M1Demo
{
    //U knjizi prodaje potrebno je evidentirati tko je kupio (Kupac), datum i iznos koji je
    //plaćen (kupac je mogao dobiti neki popust ili slično, pa se cijena može razlikovati od cijene po
    //kojoj se automobil prodaje). 
    public class Prodaja : IComparable<Prodaja>
    {
        public Prodaja(Kupac kupac, DateTime datumProdaje, int prodajnaCijena, IPopust popust, Automobil auto)
        {
            Kupac = kupac;
            DatumProdaje = datumProdaje;
            ProdajnaCijena = prodajnaCijena;
            Popust = popust;
            Auto = auto;
        }

        public Kupac Kupac { get; set; }
        public DateTime DatumProdaje { get; set; }

        public int ProdajnaCijena { get; set; }

        public IPopust Popust { get; set; }

        public Automobil Auto { get; set; }

        public int CompareTo(Prodaja other)
        {
            return (-1) * (ProdajnaCijena * Popust.DajPopust(ProdajnaCijena)).CompareTo(other.ProdajnaCijena * Popust.DajPopust(other.ProdajnaCijena));
        }

        public override string ToString()
        {
            return $"Konacna cifra {Auto.Tip} je: {(ProdajnaCijena*Popust.DajPopust(ProdajnaCijena)).UKune()}";
        }
    }
}