﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak01
{
    internal class Color
    {
        public Color() { }

        public Color(int r, int g, int b)
        {
            R = r;
            G = g;
            B = b;
        }

        // svaki integer mora imati vrijednost izmedju 0 i 255
        // validacija svih vrijednosti
        private int _r;
        public int R
        {
            // koristenje lambda izraza da bude krace
            get => _r;
            // validacija da je vrijednost izmedju 0 i 255
            set
            {
                if (!IsValidColor(value))
                {
                    throw new Exception("Color R value must be between 0 and 255!");
                }
                _r = value;
            }
        }

        private bool IsValidColor(int value)
        {
            return value >= 0 && value <= 255;
        }

        private int _g;
        public int G
        {
            get => _g;
            set
            {
                if (!IsValidColor(value))
                {
                    throw new Exception("Color G value must be between 0 and 255!");
                }
                _g = value;
            }
        }

        private int _b;
        public int B
        {
            get => _b;
            set
            {
                if (!IsValidColor(value))
                {
                    throw new Exception("Color B value must be between 0 and 255!");
                }
                _b = value;
            }
        }

        public override string ToString()
        {
            return $"({R}, {G}, {B})";
        }
    }
}
