﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak01
{
    internal class Program
    {
        static void Main(string[] args)
        {
            ISwitchable switchableLight = new LightBulb
            {
                FilamentLength = 12,
                Power = 10
            };
            switchableLight.SwitchOn();
            switchableLight.SwitchOff();
            Console.WriteLine(switchableLight);
            Console.WriteLine();

            ISwitchable switchableStove = new Stove
            {
                Manufacturer = "Gorenje",
                Type = Stove.StoveType.Gas
            };
            switchableStove.SwitchOn();
            switchableStove.SwitchOff();
            Console.WriteLine(switchableStove);
            Console.WriteLine();

            IRemoteControllable remoteController = new UniversalRemoteController();
            remoteController.SwitchOn();
            remoteController.VolumeUp();
            remoteController.VolumeDown();
            remoteController.SwitchOff();
            Console.WriteLine(remoteController);
            Console.WriteLine();

            //switchables.Add(switchableLight);
            //switchables.Add(switchableStove);
            //switchables.Add(remoteController);
            List<ISwitchable> switchables = new List<ISwitchable>
            {
                switchableLight,
                switchableStove,
                remoteController
            };

            foreach (ISwitchable s in switchables)
            {
                Console.WriteLine(s);
                s.SwitchOn();
                //if (s is IRemoteControllable)
                //{
                //    IRemoteControllable remoteControllable = s as IRemoteControllable;
                //    remoteControllable.VolumeUp();
                //    remoteControllable.VolumeDown();
                //}
                if (s is IRemoteControllable remoteControllable)
                {
                    remoteControllable.VolumeUp();
                    remoteControllable.VolumeDown();
                }
                s.SwitchOff();
            }
        }
    }
}
