﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak02
{
    class Book : IComparable<Book>
    {
        public Book(string isbn, string title, string author)
        {
            Id = idGenerator++;
            ISBN = isbn;
            Title = title;
            Author = author;
        }

        private static int idGenerator = 1;
        // Bitno je da je privatni (skriveni) set kako ga korisnik ne bi mogao mijenjati izvana
        public int Id { get; private set; }

        private string isbn;
        public string ISBN
        {
            get => isbn;
            set
            {
                if (!IsValidIsbn(value))
                {
                    throw new Exception("ISBN must have 13 digits!");
                }
                isbn = value;
            }
        }

        private bool IsValidIsbn(string value)
        {
            //foreach (char c in value)
            //{
            //    if (!char.IsDigit(c))
            //    {
            //        return false;
            //    }
            //}

            //return value.Length == 13;

            return value.Length == 13 && value.All(c => char.IsDigit(c));
        }

        public string Title { get; set; }
        public string Author { get; set; }

        public override string ToString()
        {
            return $"ID: {Id}, ISBN: {ISBN}, Title: {Title}, Author: {Author}";
        }

        public int CompareTo(Book other)
        {
            //long thisIsbn = long.Parse(ISBN);
            //long otherIsbn = long.Parse(other.ISBN);

            //if (thisIsbn > otherIsbn)
            //{
            //    return -1;
            //}
            //else if (thisIsbn < otherIsbn)
            //{
            //    return 1;
            //}
            //return 0;

            return -ISBN.CompareTo(other.ISBN);
        }
    }
}
