﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak
{
    class Course : ISignable
    {
        public string Code { get; set; }
        public string Title { get; set; }

        private int ects;
        public int ECTS
        {
            get => ects;
            set
            {
                if (value < 20 || value > 30)
                {
                    throw new Exception("ECTS points must be between 20 and 30!");
                }
                ects = value;
            }
        }

        public bool Approved { get; private set; }

        public override string ToString()
        {
            return $"Code: {Code}, Title: {Title}, Points: {ECTS.Format("ects")}, " +
                $"Approved: {(Approved ? "yes" : "no")}";
        }

        public void Sign()
        {
            Approved = true;
        }
    }
}
