﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak
{
    class Student : Person, IComparable<Student>
    {
        public Student(string firstName, string lastName, StudentType studentType) 
            : base(firstName, lastName)
        {
            Id = idGenerator++;
            Type = studentType;
        }

        public enum StudentType
        {
            Regular,
            PartTime
        }

        private static int idGenerator = 1;
        public int Id { get; private set; }
        
        public StudentType Type { get; set; }

        public override string ToString()
        {
            return $"ID: {Id}, {base.ToString()}, Type: {Type}";
        }

        public override bool Equals(object obj)
        {
            return obj is Student student &&
                   Id == student.Id;
        }

        public override int GetHashCode()
        {
            return 2108858624 + Id.GetHashCode();
        }

        // Sort DESC Id
        public int CompareTo(Student other)
        {
            return -Id.CompareTo(other.Id);
        }
    }
}
