﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak01
{
    internal class Window
    {
        public Window() : this("Window 1")
        {
            TopLeft = new Point(0, 0);
            BottomRight = new Point(80, 25);
        }

        public Window(string title)
        {
            Title = title;
        }

        public Window(string title, Point topLeft, Point bottomRight, Color color) : this(title)
        {
            TopLeft = topLeft;
            BottomRight = bottomRight;
            Color = color;
        }

        private string _title;

        public string Title
        {
            get
            {
                return _title;
            }
            set
            {
                _title = value;
            }
        }

        public string Label { get; set; }

        public Point TopLeft { get; set; }
        public Point BottomRight { get; set; }

        public Color Color { get; set; }

        public bool Active { get; set; }

        public override string ToString()
        {
            return $"Title: {Title}, Label: {Label}, " +
                $"Top left: {TopLeft}, Bottom right: {BottomRight}, " +
                $"Color: {Color}, Active: {(Active ? "Yes" : "No")}";
        }

        public int Width()
        {
            return Math.Abs(TopLeft.X - BottomRight.X);
        }

        // skraceno pisanje koristeci lambda izraz
        public int Height() => Math.Abs(TopLeft.Y - BottomRight.Y);

        public int Area()
        {
            return Width() * Height();
        }

        public int Perimeter()
        {
            return 2 * (Width() + Height());
        }

        public void Draw()
        {
            // TODO iscrtati pravokutnik sa zvjezdicama (samo vanjski obrub)
        }
    }
}
