﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak03
{
    internal class Razlomak
    {
        public Razlomak() { }

        public Razlomak(int brojnik, int nazivnik)
        {
            Brojnik = brojnik;
            Nazivnik = nazivnik;
        }

        public int Brojnik { get; set; }
        public int Nazivnik { get; set; }

        public override string ToString()
        {
            return $"{Brojnik}/{Nazivnik}";
        }

        // input => "2/3"
        // output => novi Razlomak(2, 3)
        
        // staticke metode se pozivaju direktno na klasi,
        // a ne na instanci (objektu) klase
        public static Razlomak Parse(string input)
        {
            // props[0] => "2", props[1] => "3"
            string[] props = input.Split('/');

            int brojnik = int.Parse(props[0]);
            int nazivnik = int.Parse(props[1]);

            return new Razlomak(brojnik, nazivnik);
        }

        // this je instanca prvog Razlomka
        // other (nas naziv) je instance drugog Razlomka
        public Razlomak Zbroji(Razlomak other)
        {
            // TODO logika zbrajanja koja ce vratiti rezultat
            return new Razlomak(1, 1);
        }

        // Overload operatora
        // Mora biti staticka metoda i predaju se dva objekta klase
        public static Razlomak operator +(Razlomak a, Razlomak b)
        {
            return a.Zbroji(b);
        }
    }
}
