-- radimo novu probnu tablicu 
create table Proba
(
	ID int primary key identity
)
go

-- radimo DDL okida koji spreava brisanje ili izmjenu tablica
create trigger tMijenjanjeTablica
on database
for drop_table, alter_table
as
print 'Nije uspjelo!'
rollback
go

select * from sys.triggers
go


-- pokuaj brisanja probne tablice
drop table proba

-- pokuaj mijenjanja definicije probne tablice
alter table proba
add 
	poruka nvarchar(100)
go

-- mijenjamo okida - sad spreava i kreiranje tablica
alter trigger tMijenjanjeTablica
on database
for drop_table, alter_table, create_table
as
print 'Nije uspjelo!'
rollback
go

-- pokuaj kreiranja nove tablice
create table Proba2
(
	ID int primary key identity
)
go

-- mijenjamo okida - ako nemamo rollback, brisanje, promjena ili kreiranje tablica je mogue
alter trigger tMijenjanjeTablica
on database
for drop_table, alter_table, create_table
as
print 'Uspjelo je!'
go

-- pokuaj kreiranja nove tablice je sad mogue
create table Proba2
(
	ID int primary key identity
)

-- provjera postojanja nove tablice
select * from proba2

drop trigger tMijenjanjeTablica on database
go

------------
------------
exec sp_helptext 'trtable'

select * from sys.sql_modules

select OBJECT_DEFINITION(1029578706)
------------
------------

