#include <iostream>
#include <list>
#include <forward_list>
#include <algorithm>

using namespace std;

void print_odd(int &n) 
{
	if (n % 2 != 0)
	{
		cout << n << " ";
	}
}

void print(int &n) 
{
	cout << n << " ";
}

int main() 
{
	// kreirajte listu brojeva velicine 10
	int n = 10;
	list<int> brojevi(n);

	// ispisite vrijednosti koje se nalaze u listi
	for (auto it = brojevi.begin(); it != brojevi.end(); ++it) 
	{
		cout << *it << " ";
	}
	cout << endl;

	// u listi izmijenite vrijednosti elemenata tako da vrijednosti budu 1 - 10, koristeci reverse_iterator 
	int i = 10;
	for (auto it = brojevi.rbegin(); it != brojevi.rend(); ++it) 
	{
		*it = i--;
	}

	// ispisite prvi i zadnji element liste
	cout << "prvi broj: " << brojevi.front() << endl;
	cout << "zadnji broj: " << brojevi.back() << endl;
	
	// ispisite samo neparne vrijednosti koje se nalaze u listi
	// 1.nacin
	for (auto it = brojevi.begin(); it != brojevi.end(); ++it) 
	{
		cout << *it << " ";
		// vektor omogucuje povecavanje iteratora proizvoljno, lista ne!
		// mozemo direktno povecati iterator:
		//++it;
		// ili napredovati po njemu za kolicinu zeljenih mjesta:
		advance(it, 1);
	}
	cout << endl;
	// 2. nacin
	// za for_each moramo #include <algorithm>
	for_each(brojevi.begin(), brojevi.end(), print_odd);
	cout << endl;

	// kreirajte forward_list i u nju prepisite samo parne brojeve iz liste, unazad, ali iduci unaprijed po listi
	forward_list<int> parni;
	for (auto it = brojevi.begin(); it != brojevi.end(); ++it) 
	{
		advance(it, 1); // sada preskacem neparne!
		parni.push_front(*it);
	}

	// provjera:
	for_each(parni.begin(), parni.end(), print);
	cout << endl;

	// iz forward_liste izbacite broj 10 i ispisite prvi broj
	//parni.pop_front();
	// ili:
	parni.remove(10);
	cout << "prvi parni broj: " << parni.front() << endl;

	// ispisite brojeve iz forward_liste koristeci for_each 
	for_each(parni.begin(), parni.end(), print);
	cout << endl;
	// nema reverse iteratora, pa se ne mogu ispisati unazad!

	// izbrisite sadrzaj forward_liste (jedan po jedan element)
	while (!parni.empty()) 
	{
		parni.pop_front();
	}
	// size ne postoji na forward_list:
	//cout << "parni size(): " << parni.size() << endl;

	// iz liste izbrisite sve elemente odjednom i ispiite size()
	//brojevi.clear();
	// ili:
	brojevi.erase(brojevi.begin(), brojevi.end());
	cout << "brojevi size(): " << brojevi.size() << endl;
}