/*
	Rezervacija karata za kino
*/

-- Relacijski model:

CREATE DATABASE RezervacijaKarata
GO

USE RezervacijaKarata
GO

CREATE TABLE Korisnik
(
	IDKorisnik	INT PRIMARY KEY IDENTITY(1,1),
	Ime			CHAR(25) NOT NULL,
	Prezime		CHAR(25) NOT NULL
)
GO

CREATE TABLE Film
(
	IDFilm		INT PRIMARY KEY IDENTITY(1,1),
	Naziv		CHAR(25) NOT NULL
)
GO

CREATE TABLE Lokacija
(
	IDLokacija	INT PRIMARY KEY IDENTITY(1,1),
	Naziv		CHAR(25) NOT NULL,
	Adresa		CHAR(25) NOT NULL
)
GO

CREATE TABLE Dvorana
(
	IDDvorana	INT PRIMARY KEY IDENTITY(1,1),
	Naziv		CHAR(25) NOT NULL,
	BrojMjesta	INT NOT NULL CHECK (BrojMjesta BETWEEN 50 AND 250),
	LokacijaID	INT NOT NULL REFERENCES Lokacija(IDLokacija)
)
GO

CREATE TABLE Termin
(
	IDTermin	INT PRIMARY KEY IDENTITY(1,1),
	FilmID		INT NOT NULL REFERENCES Film(IDFilm),
	DvoranaID	INT NOT NULL REFERENCES Dvorana(IDDvorana),
	Vrijeme		DATETIME NOT NULL,
	UNIQUE (FilmID, DvoranaID, Vrijeme)
)
GO

CREATE TABLE Rezervacija
(
	TerminID	INT NOT NULL REFERENCES Termin(IDTermin),
	KorisnikID	INT NOT NULL REFERENCES Korisnik(IDKorisnik),
	BrojMjesta	INT NOT NULL CHECK (BrojMjesta BETWEEN 1 AND 5),
	UNIQUE (TerminID, KorisnikID)
)
GO