locals {
  base_name   = "c9s"
  count       = 20
  base_vm_id  = 30100

  defaults = {
    cpu_cores    = 2
    memory_mb    = 4096
    ipv4_address = "dhcp"
    ipv4_gateway = ""
  }

  # auto-generate 10 VMs with defaults
  generated = {
    for i in range(1, local.count + 1) :
    format("%s-%02d", local.base_name, i) => merge(local.defaults, {
      vm_id = local.base_vm_id + i
    })
  }

  # per-VM overrides (add/edit as needed)
  overrides = {
    "c9s-03" = { cpu_cores = 4, memory_mb = 8192 }
    "c9s-07" = { cpu_cores = 8, memory_mb = 16384 }
  }

  vms = {
    for name, cfg in local.generated :
    name => merge(cfg, try(local.overrides[name], {}))
  }
}

module "c9s" {
  source   = "../../modules/vm-provisioning"
  for_each = local.vms

  name           = each.key
  node_name      = var.node_name
  vm_id          = each.value.vm_id
  template_vmid  = 50000

  cpu_cores      = each.value.cpu_cores
  memory_mb      = each.value.memory_mb

  bridge         = "vmbr200"
  datastore_id   = "ceph_hyperstorage"

  dns_domain     = "ad.local"
  dns_servers    = ["10.237.123.211", "10.237.123.212"]

  ipv4_address   = each.value.ipv4_address
  ipv4_gateway   = each.value.ipv4_gateway

  ci_user        = "operator"
  ci_password    = "oper.devops"
  ci_ssh_keys    = []
}