packer {
  required_plugins {
    proxmox = {
      source  = "github.com/hashicorp/proxmox"
      version = ">= 1.2.2"
    }
  }
}

variable "pve_url" {
  type = string
}

variable "pve_node" {
  type = string
}

variable "pve_token_id" {
  type = string
}

variable "pve_token" {
  type      = string
  sensitive = true
}

variable "iso_file" {
  type = string
}

variable "storage_pool" {
  type = string
}

variable "bridge" {
  type = string
}

variable "vm_id" {
  type    = number
  default = 30000
}

variable "vm_name" {
  type    = string
  default = "ctos9tpl"
}

variable "template_name" {
  type    = string
  default = "ctos9tpl"
}

variable "template_desc" {
  type    = string
  default = "CentOS Stream 9 (Kickstart + Cloud-Init)"
}

variable "ssh_user" {
  type    = string
}

variable "ssh_pass" {
  type    = string
}

variable "ssh_timeout" {
  type    = string
  default = "30m"
}

variable "iso_storage" {
  type = string
}

variable "ci_storage_pool" {
  type = string
}

source "proxmox-iso" "c9s" {
  proxmox_url              = var.pve_url
  insecure_skip_tls_verify = true
  username                 = var.pve_token_id
  token                    = var.pve_token

  node                 = var.pve_node
  vm_id                = var.vm_id
  vm_name              = var.vm_name
  template_name        = var.template_name
  template_description = var.template_desc

  boot_wait         = "5s"
  boot_key_interval = "150ms"
  boot              = "order=scsi0;ide2;net0"

  boot_iso {
    iso_file = var.iso_file
  }

  additional_iso_files {
    iso_storage_pool = var.iso_storage
    cd_files         = ["KS.CFG"]
    cd_label         = "OEMDRV"
    unmount          = true
  }

  boot_command = [
    "<e><wait3>",
    "<down><down>",
    "<home><right>",
    "<end> inst.ks=hd:LABEL=OEMDRV:/KS.CFG",
    "<wait><f10>"
  ]

  disks {
    type         = "scsi"
    storage_pool = var.storage_pool
    disk_size    = "60G"
    format       = "raw"
  }

  bios = "ovmf"
  efi_config {
    efi_storage_pool  = var.storage_pool
    efi_type          = "4m"
    pre_enrolled_keys = false
  }

  scsi_controller = "virtio-scsi-single"
  os              = "l26"
  machine         = "q35"
  qemu_agent      = true
  cloud_init      = true
  cloud_init_storage_pool = var.ci_storage_pool

  cpu_type = "host"
  sockets  = 2
  cores    = 2
  memory   = 4096
  numa     = true

  network_adapters {
    bridge = var.bridge
    model  = "virtio"
  }

  ssh_username = var.ssh_user
  ssh_password = var.ssh_pass
  ssh_timeout  = var.ssh_timeout
}

build {
  sources = ["source.proxmox-iso.c9s"]
}
